<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Drivers_login extends CI_Controller {

    var $thispage;

    public function __construct() {
        parent::__construct();
        if (!get_system_status()) {
            echo $this->load->view('site/system_off', '', TRUE);
            die();
        }
        if (!get_license_per('drivers')) {
            redirect("", "refresh");
        }
        set_system_timezone();
        $this->thispage = "Drivers_login";
        $this->operator_id = $this->session->userdata('operator_id');
        if (!$this->session->userdata('is_driver_login')) {
            redirect(base_url("auth/driver_login"), "refresh");
        }
        $this->load->model('admin/Drivers_model');
    }

    function index() {
        $driver = $this->Drivers_model->get_driver_wiz_data($this->session->userdata('driver_id'));
        if ($this->input->post()) {
            $this->form_validation->set_rules('name', '', 'trim');
            $extra_email = $extra_phone = '';
            if ($this->input->post('email')) {
                if ($driver->email != $this->input->post('email')) {
                    $extra_email = '|is_unique[drivers.email]';
                }
                $this->form_validation->set_rules('email', $this->lang->line('email'), "trim|valid_email$extra_email");
            }
            if ($this->input->post('phone')) {
                if ($driver->phone != $this->input->post('phone')) {
                    $extra_phone = '|is_unique[drivers.phone]';
                }
                $this->form_validation->set_rules('phone', $this->lang->line('phone'), "trim$extra_phone");
            }

            if ($this->form_validation->run() !== FALSE) {

                $data = $this->security->xss_clean($this->input->post());
                if (isset($data['new_password']) && $data['new_password']) {
                    $data['password'] = md5($data['new_password']);
                    unset($data['new_password']);
                }
                $this->db->update('drivers', $data, array('id' => $this->session->userdata('driver_id')));
                $this->session->set_flashdata('success', 1);
                redirect(base_url('drivers/Drivers_login'));
            }
        }
        $this->db->select('driver_fields_show,driver_fields_edit');
        $data['sett'] = $this->db->get('setting')->row();
        $data['countries'] = $this->Drivers_model->get_countries();
        $data['active'] = 'profile';
        $data['one'] = $driver;
        $this->load->view('site/drivers/profile', $data);
    }

    function orders() {
        $from = $to = '';
        if ($this->input->post('start_expiry')) {
            $date_arr = explode(' - ', $this->input->post('start_expiry'));
            $from = date('Y-m-d', strtotime($date_arr[0]));
            $to = date('Y-m-d', strtotime($date_arr[1]));
        }
        $data['active'] = 'orders';
        $data['orders_before_delivery'] = $this->Drivers_model->get_driver_orders($this->session->userdata('driver_id'), 2, $from, $to);
        $data['orders_in_delivery'] = $this->Drivers_model->get_driver_orders($this->session->userdata('driver_id'), 3, $from, $to);
        $data['orders_delivered'] = $this->Drivers_model->get_driver_orders($this->session->userdata('driver_id'), 4, $from, $to);
        $data['one'] = $this->Drivers_model->get_driver_wiz_data($this->session->userdata('driver_id'));
        $this->load->view('site/drivers/profile_orders', $data);
    }

    function show_order($id) {
        $data['order'] = $this->Drivers_model->get_order_details($id);
        if (!$data['order']) {
            $this->session->set_flashdata('error', $this->lang->line('data_not_found'));
            redirect(base_url('drivers/Drivers_login/orders'));
        }
        $data['one'] = $this->Drivers_model->get_driver_wiz_data($this->session->userdata('driver_id'));
        $data['active'] = 'orders';
        $data['order_id'] = $id;
        $this->load->view('site/drivers/profile_order_show', $data);
    }

    function edit_order($id) {
        $data['order'] = $this->Drivers_model->get_order($id);
        if ($data['order']->order_status == 4) {
            $this->session->set_flashdata('error', $this->lang->line('cannot_edit_delivered_orders'));
            redirect(base_url('drivers/Drivers_login/orders'));
        }
        if ($this->input->post()) {
            $update = array('order_status' => $this->input->post('order_status'));
            if ($data['order']->paid != 1) {
                $update['payment_method'] = $this->input->post('payment_method');
                if ($this->input->post('paid')) {
                    $this->db->update('bills_orders', array('paid' => $this->input->post('paid')), array('id_orders' => $id));
                }
            }
            $this->db->update('orders', $update, array('id' => $id));
            // log
            if ($data['order']->order_status != $this->input->post('order_status')) {
                $order_status = array('waiting', 'preparing', 'ready for deliver', 'delivering', 'delivered', 'canceled');
                rec_log('Change order status to : ' . $order_status[$this->input->post('order_status')] . ' order num. : ' . $id, 1, $id, $this->input->post('order_status'));
            }
            // sms
            //prepare
            $this->load->model('admin/User_model');
            $order_after_updated = $this->db->get_where('orders', array('id' => $id))->row();
            if ($this->input->post('order_status') == 1 && $data['order']->order_status != $this->input->post('order_status')) {
                $this->User_model->send_sms($id, 'preparing');
                if ($order_after_updated->payment_method == 3) {
                    $this->User_model->send_sms($id, 'payment_msg');
                }
            }
            //in delivery
            if ($this->input->post('order_status') == 3 && $data['order']->order_status != $this->input->post('order_status')) {
                $this->User_model->send_sms($id, 'in_delivery');
            }
            //delivered
            if ($this->input->post('order_status') == 4 && $data['order']->order_status != $this->input->post('order_status')) {
                $this->User_model->send_sms($id, 'delivered');
            }
            // order canceled
            if ($this->input->post('order_status') == 5 && $data['order']->order_status != $this->input->post('order_status')) {
                $this->User_model->send_sms($id, 'order_canceled');
            }

            $this->session->set_flashdata('success', 1);
            redirect(base_url('drivers/Drivers_login/orders'));
        }

        if (!$data['order']) {
            $this->session->set_flashdata('error', $this->lang->line('data_not_found'));
            redirect(base_url('drivers/Drivers_login/orders'));
        }
        $data['one'] = $this->Drivers_model->get_driver_wiz_data($this->session->userdata('driver_id'));
        $data['active'] = 'orders';
        $this->load->view('site/drivers/profile_order_edit', $data);
    }

    function lang($lang) {
        $this->session->set_userdata("language", $lang);
    }

    function logout() {
        rec_log('Logout', 1);
        $this->session->sess_destroy();
        redirect(base_url('auth/driver_login'));
    }

}
