<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Drivers extends MY_Controller {

    var $thispage;

    public function __construct() {
        parent::__construct();
        $this->thispage = "Drivers";
        if (!get_license_per('drivers')) {
            redirect("", "refresh");
        }
        $this->load->model('booking');
        $this->operator_id = $this->session->userdata('operator_id');
        if (!get_ap('drivers_module', $this->operator_id)) {
            redirect("", "refresh");
        }

        if (!$this->session->userdata('group')) {
            echo "لايمكن الاستخدام ";
            $this->session->set_flashdata('msg', 'لايمكن التعديل عليه');
            redirect($_SERVER['HTTP_REFERER']);
            exit();
        }
        $this->load->model('admin/Drivers_model');
    }

    function index() {
        $data['drivers'] = $this->Drivers_model->get_drivers();
        $data['title'] = $this->lang->line('drivers');
        $data['thispage'] = $this->thispage;
        $this->load->view('site/drivers/all', $data);
    }

    public function add() {
        if (!get_ap('add_driver', $this->operator_id)) {
            redirect("", "refresh");
        }
        $add = FALSE;
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required');
            $this->form_validation->set_rules('email', $this->lang->line('email'), 'trim|valid_email|is_unique[drivers.email]');
            if ($this->input->post('phone')) {
                $this->form_validation->set_rules('phone', $this->lang->line('phone'), 'trim|is_unique[drivers.phone]');
            }

            if ($this->form_validation->run() === FALSE) {
                $add = FALSE;
            } else {
                $add = TRUE;
                $data = $this->input->post();
                unset($data['submit']);
                $data = $this->security->xss_clean($data);
                $data['status'] = 1;
                $data['password'] = md5($data['password']);
                $result = $this->db->insert('drivers', $data);
                $this->session->set_flashdata('msg', $this->lang->line('op_success'));
                redirect(base_url('drivers/drivers'));
            }
        }
        if (!$add) {
            $data['countries'] = $this->Drivers_model->get_countries();
            $data['title'] = $this->lang->line('add-a-driver');
            $data['thispage'] = $this->thispage;
            $this->load->view('site/drivers/add', $data);
        }
    }

    public function edit($driver_id) {
        if (!get_ap('edit_driver', $this->operator_id)) {
            redirect("", "refresh");
        }
        $driver = $this->Drivers_model->get_driver($driver_id);
        $add = FALSE;
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required');
            $extra_email = $extra_phone = '';
            if ($driver->email != $this->input->post('email')) {
                $extra_email = '|is_unique[drivers.email]';
            }
            if ($driver->phone != $this->input->post('phone')) {
                $extra_phone = '|is_unique[drivers.phone]';
            }
            $this->form_validation->set_rules('email', $this->lang->line('email'), "trim|valid_email$extra_email");
            if ($this->input->post('phone')) {
                $this->form_validation->set_rules('phone', $this->lang->line('phone'), "trim$extra_phone");
            }

            if ($this->form_validation->run() === FALSE) {
                $add = FALSE;
            } else {
                $add = TRUE;
                $data = $this->input->post();
                unset($data['submit']);
                $data = $this->security->xss_clean($data);
                if (isset($data['new_password']) && $data['new_password']) {
                    $data['password'] = md5($data['new_password']);
                    unset($data['new_password']);
                }
                $result = $this->db->update('drivers', $data, array('id' => $driver_id));
                $this->session->set_flashdata('msg', $this->lang->line('op_success'));
                redirect(base_url('drivers/drivers'));
            }
        }
        if (!$add) {
            $data['countries'] = $this->Drivers_model->get_countries();
            $data['driver'] = $driver;
            $data['title'] = $this->lang->line('edit_driver');
            $data['thispage'] = $this->thispage;
            $this->load->view('site/drivers/edit', $data);
        }
    }

    public function del($ticket_id) {
        if (!get_ap('delete_driver', $this->operator_id)) {
            redirect("", "refresh");
        }
        $this->db->delete('drivers', array('id' => $ticket_id));
        $this->session->set_flashdata('msg', $this->lang->line('op_success'));
        redirect(base_url('drivers/drivers'));
    }

    function change_driver_status($id, $status) {
        $this->db->update('drivers', array('status' => $status), array('id' => $id));
        $this->session->set_flashdata('msg', 'success');
        redirect('drivers/drivers');
    }

    function report() {
        if (!get_ap('drivers_report', $this->operator_id)) {
            redirect("", "refresh");
        }
        $from = $to = '';
        if ($this->input->post('start_expiry')) {
            $date_arr = explode(' - ', $this->input->post('start_expiry'));
            $from = date('Y-m-d', strtotime($date_arr[0]));
            $to = date('Y-m-d', strtotime($date_arr[1]));
        }
        $data['drivers'] = $this->Drivers_model->get_drivers_report($from, $to);
        $data['title'] = $this->lang->line('drivers_report');
        $data['thispage'] = $this->thispage;
        $this->load->view('site/drivers/report', $data);
    }
    
    function fields_settings() {
        if (!get_license_per('data_managment')) {
            redirect("", "refresh");
        }
        if (!get_ap('drivers_data_control', $this->operator_id) == 1) {
            redirect("", "refresh");
        }
        if ($this->input->post()) {

            $this->db->update('setting', array(
                'driver_fields_show' => is_array($this->input->post('show')) ? implode(',', $this->input->post('show')) : '',
                'driver_fields_edit' => is_array($this->input->post('edit')) ? implode(',', $this->input->post('edit')) : '',
            ));
            $this->session->set_flashdata('success', 'success');
            redirect(base_url('drivers/Drivers/fields_settings'));
        }
        $this->db->select('driver_fields_show,driver_fields_edit');
        $data['data'] = $this->db->get('setting')->row();
        $data['title'] = $this->lang->line('setting');
        $data['thispage'] = $this->thispage;
        $this->load->view('site/drivers/fields_settings', $data);
    }

}
