<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class User extends BD_Controller {

    function __construct() {
        // Construct the parent class
        parent::__construct();
        $this->auth();
        $this->load->model('api/M_user');
    }

    public function userData_post() {
        $notFound = ['status' => 'error', 'msg' => 'User Not Found', 'username' => '', 'email' => '', 'total_balance' => '', 'image' => ''];
        $user_data = $this->M_user->getUserData($this->user_data->id);
        if (empty($user_data)) {
            $this->response($notFound, REST_Controller::HTTP_OK);
        }
        if ($user_data['image'] != '') {
            $user_data['image'] = base_url('public/upload/userimage/' . $user_data['image']);
        }
        $user_data['status'] = 'success';
        $user_data['msg'] = '';
        $this->response($user_data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
    }

    public function userPointsHistory_post() {
        $notFound = ['status' => 'error', 'msg' => 'User Not Found', 'user_ponits' => '', 'user_points_history' => ''];
        $user_points = $this->M_user->userPoints($this->user_data->id);
        $user_points_history = $this->M_user->userPointsHistory($this->user_data->id);
        if (empty($user_points)) {
            $this->response($notFound, REST_Controller::HTTP_OK);
        }
        $response['user_ponits'] = $user_points;
        $response['user_points_history'] = $user_points_history;
        $response['status'] = 'success';
        $response['msg'] = '';
        $this->response($response, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
    }

    public function getAwards_post() {
        $response['data'] = $this->M_user->userAwards($this->user_data->id);
        $response['status'] = 'success';
        $this->response($response, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
    }

    public function getSubscription_post() {
        $response['data'] = $this->M_user->userSubscriptions($this->user_data->id);
        $response['status'] = 'success';
        $this->response($response, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
    }

    public function getPersonalInfo_post() {
        $response['data'] = $this->M_user->userPersonalInfo($this->user_data->id);
        if (!$response['data']) {
            $notfound = array('status' => 'error', 'msg' => 'User Not Found', 'data' => '');
            $this->response($notfound, REST_Controller::HTTP_OK);
        }
        $response['status'] = 'success';
        $response['msg'] = '';
        $this->response($response, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
    }

    public function getQuraanSessions_post() {
        $type = -1;
        $date = $rating = '';
        if ($this->input->post('type')) {
            $types = array('hfz' => 0, 'mrg3a' => 1, 'srd' => 2, 'tlawa' => 3, 'tlken' => 4, 'test' => 5);
            $type = $types[$this->input->post('type')];
        }
        if ($this->input->post('date')) {
            $date = date('Y-m-d', strtotime($this->input->post('date')));
        }
        if ($this->input->post('rating')) {
            $rating = $this->input->post('rating');
        }
        $response['tsme3_all_pages_count'] = $this->M_user->userTsme3Counts($this->user_data->id, $type, $date, $rating);
        $response['sessions'] = $this->M_user->userQuraanSessions($this->user_data->id, $type, $date, $rating);
        $response['status'] = 'success';
        $response['msg'] = '';
        $this->response($response, REST_Controller::HTTP_OK);
    }

    public function getSessionDetails_post() {
        $session_id = $this->input->post('session_id');
        $response['session'] = $this->M_user->userSessionDetails($this->user_data->id, $session_id);
        if (!$response['session']) {
            $notfound = array('status' => 'error', 'msg' => 'Session Not Found', 'session' => '');
            $this->response($notfound, REST_Controller::HTTP_OK);
        }
        $response['status'] = 'success';
        $response['msg'] = '';
        $this->response($response, REST_Controller::HTTP_OK);
    }

    public function getAwardsList_post() {
        $response['data'] = $this->M_user->get_awards_list();
        $response['status'] = 'success';
        $response['msg'] = '';
        $this->response($response, REST_Controller::HTTP_OK);
    }

    public function requestAward_post() {
        $award_id = $this->input->post('award_id');

        $award = $this->M_user->getAwardById($award_id);
        $award_point = $award->award_point;
        $result = $this->M_user->userPoints($this->user_data->id);

        if ($result['total_balance'] >= $award_point) {
            $award_data = array();
            $award_data['user_id'] = $this->user_data->id;
            $award_data['award_id'] = $award_id;
            $award_data['award_history_point'] = $award_point;
            $award_data['memo'] = '';
            $award_data['award_status'] = 0;
            $award_data['member_id'] = 0;
            $this->db->insert('pts_award_history', $award_data);

            $response['status'] = 'success';
            $response['msg'] = '';
            $this->response($response, REST_Controller::HTTP_OK);
        } else {
            $response['status'] = 'error';
            $response['msg'] = "Sorry you don't have enough balance";
            $this->response($response, REST_Controller::HTTP_OK);
        }
    }

    public function editUserProfileData_post() {
        $update = array('name' => $this->input->post('name'),
            'email' => $this->input->post('email'),
            'phone' => $this->input->post('phone'),
            'phone_father' => $this->input->post('father_phone')
        );
        if ($this->input->post('password')) {
            $update['password'] = $this->input->post('password');
        }
        if ($this->M_user->update_user_profile($update, $this->user_data->id)) {
            $response['status'] = 'success';
            $response['msg'] = '';
            $this->response($response, REST_Controller::HTTP_OK);
        } else {
            $response['status'] = 'error';
            $response['msg'] = "error occurred while updating";
            $this->response($response, REST_Controller::HTTP_OK);
        }
    }

    public function getStaticData_post() {
        $type = $this->input->post('type');
        if (!$type) {
            $response['status'] = 'error';
            $response['msg'] = "missing required parameter";
            $this->response($response, REST_Controller::HTTP_BAD_REQUEST);
        }
        $response['data'] = $this->M_user->get_data($type);
        $response['status'] = 'success';
        $response['msg'] = '';
        $this->response($response, REST_Controller::HTTP_OK);
    }

    public function addUserAddress_post() {
        $region = $this->input->post('region');
        if (is_numeric($region)) {
            $region = $this->M_user->get_data_region($this->input->post('region'));
            if (!$region) {
                $response['status'] = 'error';
                $response['msg'] = "Incorrect region";
                $this->response($response, REST_Controller::HTTP_BAD_REQUEST);
            }
        }
        $add = array('region' => $region,
            'blocks' => $this->input->post('block'),
            'street' => $this->input->post('street'),
            'jadah' => $this->input->post('jadah'),
            'building_num' => $this->input->post('building_num'),
            'floor' => $this->input->post('floor'),
            'door_no' => $this->input->post('door_no'),
            'address_link' => $this->input->post('address_link'),
            'user_id' => $this->user_data->id
        );
        if ($this->M_user->add_user_address($add)) {
            $response['status'] = 'success';
            $response['msg'] = '';
            $this->response($response, REST_Controller::HTTP_OK);
        } else {
            $response['status'] = 'error';
            $response['msg'] = "error occurred while inserting";
            $this->response($response, REST_Controller::HTTP_OK);
        }
    }

    public function editUserAddress_post() {
        $region = $this->input->post('region');
        if (is_numeric($region)) {
            $region = $this->M_user->get_data_region($this->input->post('region'));
            if (!$region) {
                $response['status'] = 'error';
                $response['msg'] = "Incorrect region";
                $this->response($response, REST_Controller::HTTP_BAD_REQUEST);
            }
        }
        $address_id = $this->input->post('address_id');
        if (!$address_id) {
            $response['status'] = 'error';
            $response['msg'] = "Missing address id";
            $this->response($response, REST_Controller::HTTP_BAD_REQUEST);
        }
        if (!$this->M_user->checkIfThisUserAddress($address_id, $this->user_data->id)) {
            $response['status'] = 'error';
            $response['msg'] = "Address Not Found or not Assigned to This User";
            $this->response($response, REST_Controller::HTTP_BAD_REQUEST);
        }
        $update = array('region' => $region,
            'blocks' => $this->input->post('block'),
            'street' => $this->input->post('street'),
            'jadah' => $this->input->post('jadah'),
            'building_num' => $this->input->post('building_num'),
            'floor' => $this->input->post('floor'),
            'door_no' => $this->input->post('door_no'),
            'address_link' => $this->input->post('address_link')
        );
        if ($this->M_user->update_user_address($update, $address_id)) {
            $response['status'] = 'success';
            $response['msg'] = '';
            $this->response($response, REST_Controller::HTTP_OK);
        } else {
            $response['status'] = 'error';
            $response['msg'] = "error occurred while updating";
            $this->response($response, REST_Controller::HTTP_OK);
        }
    }

    public function UserInvoices_post() {
        $response['data'] = $this->M_user->get_invoices($this->user_data->id);
        $response['status'] = 'success';
        $response['msg'] = '';
        $this->response($response, REST_Controller::HTTP_OK);
    }

    public function getInvoice_post() {
        $invoice_num = $this->input->post('inv_num');
        if (!$invoice_num || !is_numeric($invoice_num)) {
            $response['status'] = 'error';
            $response['msg'] = "Incorrect invoice num";
            $this->response($response, REST_Controller::HTTP_BAD_REQUEST);
        }
        if (!$this->M_user->checkIfThisUserInvoice($invoice_num, $this->user_data->id)) {
            $response['status'] = 'error';
            $response['msg'] = "Invoice Not Found or not Assigned to This User";
            $this->response($response, REST_Controller::HTTP_BAD_REQUEST);
        }
        $response['data'] = $this->M_user->get_invoice($invoice_num);
        $response['status'] = 'success';
        $response['msg'] = '';
        $this->response($response, REST_Controller::HTTP_OK);
    }

    public function getAttendance_post() {
        $product = $date = $present = '';
        if ($this->input->post('product')) {
            $product = $this->input->post('product');
        }
        if ($this->input->post('date')) {
            $date = $this->input->post('date');
        }
        if ($this->input->post('type')) {
            $present = $this->input->post('type');
        }
        $response['data'] = $this->M_user->getStatisAttendance($this->user_data->id, $product, $date, $present);
        $response['details'] = $this->M_user->getAttendance($this->user_data->id, $product, $date, $present);
        $response['status'] = 'success';
        $this->response($response, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
    }
    
    public function getMembershipProducts_post() {
        $response['data'] = $this->M_user->getMembershipProducts();
        $response['status'] = 'success';
        $this->response($response, REST_Controller::HTTP_OK);
    }
    
    public function getUserMsgs_post() {
        $response['private_msgs'] = $this->M_user->get_msgs($this->user_data->id);
        $response['announcement'] = $this->M_user->get_announc();
        $response['status'] = 'success';
        $this->response($response, REST_Controller::HTTP_OK);
    }

}
