<?php

defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Auth extends BD_Controller {

    function __construct() {
        // Construct the parent class
        parent::__construct();
        // Configure limits on our controller methods
        // Ensure you have created the 'limits' table and enabled 'limits' within application/config/rest.php
        $this->methods['users_get']['limit'] = 500; // 500 requests per hour per user/key
        $this->methods['users_post']['limit'] = 100; // 100 requests per hour per user/key
        $this->methods['users_delete']['limit'] = 50; // 50 requests per hour per user/key
        $this->load->model('api/M_main');
    }

    public function login_post() {
        $u = $this->post('username'); //Username Posted
        $p = md5(md5($this->post('password'))); //Pasword Posted
        //$q = array('username' => $u); //For where query condition
        $kunci = $this->config->item('thekey');
        $invalidLogin = ['status' => 'Invalid Login', 'token' => '']; //Respon if login invalid
        $deactivatedAccount = ['status' => 'Deactivated Account', 'token' => '']; //Respon if deactivated account
        if ($u == '' || $this->post('password') == '') {
            $this->response($invalidLogin, REST_Controller::HTTP_NOT_FOUND);
        }
        $val = $this->M_main->get_user($u); //Model to get single data row from database base on username
        if (!$val) {
            $this->response($invalidLogin, REST_Controller::HTTP_NOT_FOUND);
        }
        if ($val->approve_status == 0) {
            $this->response($deactivatedAccount, REST_Controller::HTTP_NOT_FOUND);
        }
        $match = $val->pass;   //Get password for user from database
        if ($p == $match) {  //Condition if password matched
            $token['id'] = $val->id;  //From here
            $token['username'] = $u;
            $date = new DateTime();
            $token['iat'] = $date->getTimestamp();
            $token['exp'] = $date->getTimestamp() + 60 * 60 * 5; //To here is to generate token
            $output['status'] = 'success';
            $output['token'] = JWT::encode($token, $kunci); //This is the output token

            $this->set_response($output, REST_Controller::HTTP_OK); //This is the respon if success
        } else {
            $this->set_response($invalidLogin, REST_Controller::HTTP_NOT_FOUND); //This is the respon if failed
        }
    }

}
