<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Absent extends MY_Controller {

    var $cats;
    var $thispage;

    public function __construct() {
        parent::__construct();
        if (!get_license_per('attendance')) {
            redirect("", "refresh");
        }
        $this->load->model('booking');
        // $this->load->helper('site_helper');
        $this->operator_id = $this->session->userdata('operator_id');
        
        if (get_ap('student', $this->operator_id) == 1) {
            
        } else {
            redirect("", "refresh");
        }
        $this->thispage = "user";
    }

    public function index() {
        
    }

    public function add($id) {
        $this->form_validation->set_rules('date', 'date', 'trim|required');
        if ($this->form_validation->run() != FALSE) {
//        if ($this->input->server('REQUEST_METHOD') == "POST") {
            //$data = $this->input->post('absent');
            $date = $this->input->post('date');
            $product = $id; // add date column in view file
            $present = $this->input->post('present');
            $absent = $this->input->post('absent');
            $late = $this->input->post('late');
            $exist = array_intersect($present, $absent);
            $exist += array_intersect($absent, $late);
            $exist += array_intersect($present, $late);
            if (!empty($exist)) {
                $data['exist'] = $exist;
                $data['title'] = $this->lang->line('add-attendance');
                $data['cats'] = $this->cats;
                $data['id'] = $id;
                $data['thispage'] = $this->thispage;
                $this->load->view('site/absent/add', $data);
                return;
            }
            $new_data = array();
//            foreach ($data as $key => $value) {
            for ($i = 0; $i < 3; $i++) {
                if ($i == 0) {
                    $arr = $absent;
                } else if ($i == 1) {
                    $arr = $present;
                } else if ($i == 2) {
                    $arr = $late;
                }
                foreach ($arr as $ele) {
                    $user_id = $this->db->get_where('bills_user', array('username' => $ele))->row()->id;
                    $new_data = array(
                        'user_id' => $user_id,
                        'present' => $i,
                        'date' => $date,
                        'product_id' => $product,
                        'create_on' => date('m-d-Y h:m:sa')
                    );
//            }
                    $attend_exist = $this->db->get_where('gyab', array('date' => $date, 'user_id' => $user_id, 'product_id' => $product))->row();
                    if (!$attend_exist) {
                        $this->db->insert('gyab', $new_data);
                    } else {
                        $this->db->update('gyab', $new_data, array('sno' => $attend_exist->sno));
                    }
                }
            }
            $this->session->set_flashdata('success', $this->lang->line('op_success'));
            redirect('producer');
        }
        $data['title'] = $this->lang->line('add-attendance');
        $data['cats'] = $this->cats;
        $data['id'] = $id;
        $data['thispage'] = $this->thispage;
        $this->load->view('site/absent/add', $data);
    }

    function absent_summary($product_id) {
        if ($this->input->post()) {
            if ($this->input->post('start_expiry')) {
                $date_arr = explode(' - ', $this->input->post('start_expiry'));
                $from = date('Y-m-d', strtotime($date_arr[0]));
                $to = date('Y-m-d', strtotime($date_arr[1]));
                $this->db->where(array('gyab.date >=' => $from, 'gyab.date <=' => $to));
            }
            if (!empty($this->input->post('username'))) {
                $this->db->where_in('bills_user.username', $this->input->post('username'));
            }
            if (!empty($this->input->post('attend_status'))) {
                $attend_arr = array();
                $attend_status_arr = array($this->lang->line('absent'), $this->lang->line('present'), $this->lang->line('late'));
                foreach ($this->input->post('attend_status') as $attend_s) {
                    $index = array_search($attend_s, $attend_status_arr);
                    if ($index !== FALSE) {
                        $attend_arr[] = $index;
                    }
                }
                if (!empty($attend_arr)) {
                    $this->db->where_in('gyab.present', $attend_arr);
                }
            }
        }
        $this->db->select('gyab.user_id,bills_user.username,count(gyab.sno) as total_days');
        $this->db->select('SUM(CASE WHEN gyab.present = 1 THEN 1 ELSE 0 END) AS present');
        $this->db->select('SUM(CASE WHEN gyab.present = 0 THEN 1 ELSE 0 END) AS absent');
        $this->db->select('SUM(CASE WHEN gyab.present = 2 THEN 1 ELSE 0 END) AS late');
        $this->db->group_by('gyab.user_id,bills_user.username');
        $this->db->join('bills_user', 'bills_user.id=gyab.user_id');
        $query = $this->db->get_where('gyab', array('gyab.product_id' => $product_id));
        $data['all_groups'] = $query->result();
        $data['username'] = $this->db->get('bills_user')->result();
        $data['title'] = $this->lang->line('absent');
        $data['product_id'] = $product_id;
        $data['thispage'] = 'absent';
        $this->load->view('site/absent/absent_summary', $data);
    }

    function detailed_absent($product_id, $user_id, $type = '') {
        $this->db->select('bills_user.username,gyab.*');
        $this->db->join('bills_user', 'bills_user.id=gyab.user_id');
        if ($type!=='') {
            $this->db->where('gyab.present', $type);
        }
        $query = $this->db->get_where('gyab', array('gyab.product_id' => $product_id, 'gyab.user_id' => $user_id));
        $data['all_groups'] = $query->result();
        $data['username'] = $this->db->get_where('bills_user', array('approve_status' => 1))->result();
        $data['title'] = $this->lang->line('absent');
        $data['product_id'] = $product_id;
        $data['thispage'] = 'absent';
        $this->load->view('site/absent/absent_detailed', $data);
    }
    
    function read_excel() {
        $file = './tblAyas.xlsx';
        
        //load the excel library
        $this->load->library('excel');
        
        //read file from path
        $objPHPExcel = PHPExcel_IOFactory::load($file);
        
        //get only the Cell Collection
        $cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
        
        //extract to a PHP readable array format
        $cols = array('ayah_id','surah_id','ayah_num','ayah_percentage');
        $prev_row = 2;
        $col=0;
        foreach ($cell_collection as $cell) {
            
            $column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
            $row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
            $data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
            
            //The header will/should be in row 1 only. of course, this can be modified to suit your need.
            if ($row == 1) {
                continue;
            } else {
                if($row != $prev_row){
                    $col=0;
                    $this->db->insert('quran_ayah',$arr_data);
                    //print_R($arr_data);die;
                }
                $arr_data[$cols[$col]] = $data_value;
            }
            $prev_row = $row;
            $col++;
        }
        //print_R($arr_data);die;
    }
}

?>