<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Language extends CI_Controller {

    var $cats;
    var $thispage;

    public function __construct() {
        parent::__construct();

        if (strtolower($this->router->fetch_method()) != 'lang' && !get_license_per('language')) {
            redirect("", "refresh");
        }
        // echo 'KKKKKKK';die;
        $this->load->model('booking');
        $this->load->model('Language_Model');
        $this->thispage = "language";
        $this->operator_id = $this->session->userdata("operator_id");
        if (strtolower($this->router->fetch_method()) == 'lang' || (get_ap('language', $this->operator_id) == 1 || $this->session->has_userdata('is_teacher_login') || $this->session->has_userdata('is_driver_login'))) {
            
        } else {
            redirect("", "refresh");
        }
    }

    function lang($lang) {
        $this->session->set_userdata("language", $lang);
        /* if(!empty($this->session->userdata("language")))
          $data['msg']=1;
          echo json_encode($data);
          }else{
          $data['msg']=0;
          echo json_encode($data);
          } */
    }

    function search() {
        if ($this->input->server('REQUEST_METHOD') == "POST") {
            $match = $this->input->post('match');
//            if($this->session->userdata('language') == 'english')
//            {
            $this->db->like('english', $match, 'both');
            $this->db->or_like('arabic', $match, 'both');
            $query = $this->db->get('language')->result();
//            }else{
//                    
//                $query = $this->db->get('language')->result();
//            }
            if ($query) {
                $query_arr = ' ';
                foreach ($query as $key => $page) {
                    $query_arr .= "<option value='" . $page->label . "'data-arabic='" . $page->arabic . "'data-english='" . $page->english . "'>" . $page->english . '----------' . $page->arabic . "</option>";
                }
                $query_arr;
            } else {
                $query_arr = "<option>no results</option>";
            }
            echo $query_arr;
        }
    }

    public function index() {
        if (!get_ap('language', $this->operator_id)) {
            redirect("", "refresh");
        }
        $data['pages'] = $this->Language_Model->get_language();
        $data['title'] = 'Language';
        //$data['view'] = '../controllers/views/' . $this->thispage . '/index';
        $data['thispage'] = $this->thispage;
        // print_r($data['result']);die();
        $this->load->view('site/' . $this->thispage . '/index', $data);
    }

    public function all() {

        $this->db->from('language');
        $this->db->order_by('id', 'asc');
        $data['result'] = $this->db->get()->result();
        $data['title'] = $this->lang->line('language');
        // $data['view'] = '../controllers/views/' . $this->thispage . '/all';
        $data['thispage'] = $this->thispage;
        // print_r($data['result']);die();
        $this->load->view('site/' . $this->thispage . '/all', $data);
    }

    public function add($cats = 1) {
        $add = FALSE;
        $this->cats = $cats;
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('english', '', 'trim|required');
            $this->form_validation->set_rules('arabic', '', 'trim|required');
            if ($this->form_validation->run() === FALSE) {

                $add = FALSE;
            } else {
                $add = TRUE;
                $data = array(
                    'english' => $this->input->post('english'),
                    'arabic' => $this->input->post('arabic'),
                    'label' => slug($this->input->post('english')),
                    'create_on' => date("Y-m-d h:m:sa"),
                );
                $result = $this->db->insert('language', $data);
                if ($result) {
                    $this->session->set_flashdata('msg', 'success');
                    redirect(base_url('' . $this->thispage . '/all/'));
                }
            }
        }
        if (!$add) {
            $data['title'] = 'Language';
            $data['thispage'] = 'language';
            //$data['view'] = '../controllers/views/' . $this->thispage . '/add';
            $this->load->view('site/' . $this->thispage . '/add', $data);
        }
    }

    public function edit($id = " ") {
        if ($this->input->server('REQUEST_METHOD') == "POST") {
            $data = $this->input->post();
            $data['label'] = slug($data['english']);
            $data['last_update'] = date('Y-m-d h:m:sa');
            $this->db->where('id', $id);
            $result = $this->db->update('language', $data);
            if ($result) {
                $this->session->set_flashdata('msg', 'change successfully');
                redirect(base_url('' . $this->thispage . '/all/'));
            }
        }
        $this->db->from('language');
        $this->db->where('id', $id);
        $data['result'] = $this->db->get()->row();
        $data['title'] = 'edit';
        $data['thispage'] = 'language';
        // $data['view'] = '../controllers/views/' . $this->thispage . '/edit';
        $this->load->view('site/' . $this->thispage . '/all', $data);
    }

    public function delete($id = "") {
        $this->db->where('id', $id);
        $result = $this->db->delete('language');
        if ($result) {
            $this->session->set_flashdata('msg', 'delete successfully');
            redirect(base_url('' . $this->thispage . '/all/'));
        }
    }

    // =======================================================
    function save_content() {
        if (!get_ap('language', $this->operator_id)) {
            return;
        }
        if ($this->input->server("REQUEST_METHOD") == "POST") {
            $data['status'] = 0;

            $json_data = $this->input->post('json_data');
            if ($json_data) {
                $json_array = json_decode($json_data, true);
                // $json_array = $json_data;
                /* if(count($json_array) > 0 ){
                  foreach ($json_array as $key => $array) {
                  $data['english']=$array[0];
                  $data['arabic']=$array[1];
                  $this->db->where('id',$key);
                  $this->db->update('language',$data);
                  $data['status'] = 1;
                  $data['message'] = "Successfully Saved";

                  }
                  } */
                if (count($json_array) > 0) {
                    foreach ($json_array as $key => $array) {
                        //echo $key;die;
                        $this->db->where('label', $key);
                        $this->db->set('english', $array[0]);
                        $this->db->set('arabic', $array[1]);
                        $this->db->update('language');
                        $data['status'] = 1;
                        $data['message'] = "Successfully Saved";
                        echo json_encode($data);
                    }
                } else {
                    $data['message'] = "no changes done";
                }
            } else {
                $data['message'] = "no changes done";
            }
            echo json_encode($data);
        }
    }

    function create($page = "") {
        if ($this->input->server("REQUEST_METHOD") == "POST") {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('english', 'English', 'required|trim|xss_clean');
            $this->form_validation->set_rules('arabic', 'Arabic', 'required|trim|xss_clean');

            if ($this->form_validation->run() == TRUE) {

                //pr($_POST);die;
                $data = $this->input->post();

                if ($data['page'] == "others")
                    $data['page'] = $data['other'];
                unset($data['other']);
                unset($data['submit_page']);


                $data['label'] = gen_slug(strtolower($data['page']) . " " . $data['english']);

                $insert_id = $this->Language_Model->save($data);

                $this->session->set_flashdata('message', $this->db->last_query());
                if ($this->input->post('submit_page') == "formSave")
                    redirect('language', 'refresh');
                else
                    redirect('language/create/' . $page, 'refresh');
            }
        }
        $data['title'] = $this->lang->line('language_add_language');
        $data['page_list'] = $this->Language_Model->get_language();
        $data['page'] = $page;
        $this->load->view("language/create", $data);
    }

}

?>