<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Expense extends MY_Controller {
    var $cats;
    var $thispage;
    public function __construct() {
        parent::__construct();
        if (!get_license_per('accountant')) {
            redirect("", "refresh");
        }
        $this->load->model('booking');
        $this->thispage = "expense";
        $this->db->from('bills_orders');
        $this->db->where("start_date_t  IS NULL");
        $data['all_groups'] = $this->db->get()->result_array();
        $this->operator_id = $this->session->userdata('operator_id');
         if(get_ap('accountant',$this->operator_id)==1){ }else{ redirect("","refresh");}
        
    }

    public function index($cats = 1) {
        if (get_ap('expense', $this->operator_id) != 1) {
            redirect("","refresh");
        }
        $this->cats = $cats;
        $this->all($cats);
    }

    public function all($page = 1, $id_producer = '', $active = '') {
        $searchfor = $this->security->xss_clean($this->input->get('search'));
        $this->db->from('expense');
        $this->db->order_by('id', 'desc');
        $data['all_groups'] = $this->db->get()->result_array();
        $data['title'] = $this->lang->line('expenses');
        // $data['view'] = '../controllers/views/'. $this->thispage .'/all';
        $data['thispage'] = $this->thispage;
        $this->load->view('site/'. $this->thispage .'/all', $data);
    }

    public function add($cats = 1) {
        if (get_ap('ex_add', $this->operator_id) != 1) {
            redirect("","refresh");
        }
        $add = FALSE;
        $this->cats = $cats;
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('expense_name', '', 'trim|required');
            $this->form_validation->set_rules('expense_price', '', 'trim|required');
            $this->form_validation->set_rules('expense_date', '', 'trim|required');
            if ($this->form_validation->run() === FALSE) {
                $add = FALSE;
            } else {
                $data['expense_name'] = $this->input->post('expense_name');
                $data['expense_price'] = $this->input->post('expense_price');
                $data['expense_date'] = $this->input->post('expense_date');
                $data['updated_by'] = $this->session->userdata('admin_id');
                $data['create_on'] = date('Y-m-d h:m:sa');
                        $data = $this->security->xss_clean($data);
                        $result = $this->db->insert('expense', $data);
                if ($result) {
                    $this->session->set_flashdata('msg', '');
                    redirect(base_url('expense/index/'));
                }
            }
        }
        if (!$add) {
            $data['title'] = $this->lang->line('add-expense');
            $data['cats'] = $this->cats;
            $data['thispage'] = $this->thispage;
            // $data['view'] = '../controllers/views/'. $this->thispage .'/add';
            $this->load->view('site/'. $this->thispage .'/add', $data);
        }
    }
    public function printorder($id) {

        $query = $this->db->get_where('bills_orders', array('id' => $id));
        $data['show'] = $query->row_array();
        $query = $this->db->get_where('bills_user', array('id' => $data['show']['id_user']));
        $data['show2'] = $query->row_array();
        $query = $this->db->get_where('bills_producer', array('id' => $data['show']['id_producer']));
        $data['producer'] = $query->row_array();
        $add = FALSE;
        $data['title'] = '  عرض عميل';
        $data['thispage'] = ''. $this->thispage .'';
        $data['view'] = '../controllers/views/'. $this->thispage .'/show';
        $this->load->view('../controllers/views/'. $this->thispage .'/show', $data);
    }

    public function del($id) {
        $query = $this->db->get_where('bills_orders', array('id' => $id));
        $data['edit'] = $query->row_array();
        $this->db->where('id', $id);
        $result = $this->db->delete('bills_orders');
        if (count($result) > 0) {
            $this->session->set_flashdata('msg', 'تم حذف  القسم بفضل الله!');
            redirect(base_url('Multi_orders/index/'));
        }
    }
    public function addcategory($cats = 1) {
        if (get_ap('ex_cat_add', $this->operator_id) != 1) {
            redirect("","refresh");
        }
        $add = FALSE;
        $this->cats = $cats;
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('category_name', 'category name', 'trim|required');
            if ($this->form_validation->run() === FALSE) {
                $add = FALSE;
            } else {
                $data['category_name'] = $this->input->post('category_name');
                $data['category_status'] = 1;
                $data['create_on'] = date('Y-m-d h:m:sa');
                $data = $this->security->xss_clean($data);
                $result = $this->db->insert('expense_category', $data);
                if ($result) {
                    $this->session->set_flashdata('msg', '');
                    redirect(base_url('expense/category_list/'));
                }
            }
        }
        if (!$add) {
            $data['title'] = $this->lang->line('category');
            $data['cats'] = $this->cats;
            $data['thispage'] = $this->thispage;
            // $data['view'] = '../controllers/views/'. $this->thispage .'/addcategory';
            $this->load->view('site/'. $this->thispage .'/addcategory', $data);
        }
    }
    public function category_list($page = 1, $id_producer = '', $active = '') {
         if (get_ap('ex_cat', $this->operator_id) != 1) {
            redirect("","refresh");
        }
        $searchfor = $this->security->xss_clean($this->input->get('search'));
        $this->db->from('expense_category');
        $this->db->order_by('id', 'desc');
        $data['all_groups'] = $this->db->get()->result_array();
        $data['title'] = $this->lang->line('categories');
        // $data['view'] = '../controllers/views/'. $this->thispage .'/category_list';
        $data['thispage'] = $this->thispage;
        $this->load->view('site/'. $this->thispage .'/category_list', $data);
    }
    public function editcategory($id,$cats="")
    {
        if (get_ap('ex_cat_edit', $this->operator_id) != 1) {
            redirect("","refresh");
        }
        $add = FALSE;
        $this->cats = $cats;
        if ($this->input->post('submit')) 
        {
            $this->form_validation->set_rules('category_name', 'category name', 'trim|required');
            if ($this->form_validation->run() === FALSE) 
            {
                $add = FALSE;
            } else 
            {
                $data['category_name'] = $this->input->post('category_name');
                $data['last_update'] = date('Y-m-d h:m:sa');
                $data = $this->security->xss_clean($data);
                $this->db->where('id',$id);
                $result = $this->db->update('expense_category',$data);
                if ($result)
                {
                    $this->session->set_flashdata('msg', '');
                    redirect(base_url('expense/category_list/'));
                }
            }
        }
        if (!$add) {
            $data['title'] = $this->lang->line('edit');
            $data['cats'] = $this->cats;
            $data['thispage'] = $this->thispage;
            $this->db->where('id',$id);
            $data['result'] = $this->db->get('expense_category')->row();    
            // $data['view'] = '../controllers/views/'. $this->thispage .'/editcategory';
            $this->load->view('site/'. $this->thispage .'/editcategory', $data);
        }
    }
    function category_status($id,$status)
    {
        if ($status== 1) 
        {
            $data['category_status'] = 0;
        }
        else if ($status == 0) {
            $data['category_status'] = 1;
        }else{
            $data['category_status'] = 0;   
        }
            $this->db->where('id',$id);
            $result = $this->db->update('expense_category', $data);
            if ($result) {
                $this->session->set_flashdata('msg', '');
                redirect(base_url('expense/category_list/'));
            }
    }public function catdel($id) {
        if (get_ap('ex_cat_del', $this->operator_id) != 1) {
            redirect("","refresh");
        }
        $this->db->where('id', $id);
        $result = $this->db->delete('expense_category');
        if ($result) {
            $this->session->set_flashdata('msg', 'تم حذف  القسم بفضل الله!');
            redirect(base_url('expense/category_list/'));
        }
    }
}
?>