<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Datas extends MY_Controller {
    var $cats;
    var $thispage;
    public function __construct() {
        parent::__construct();
        $this->load->model('booking');
        $this->load->model('Language_Model');
        $this->thispage = "datas";
        $this->operator_id = $this->session->userdata("operator_id");
        if(get_ap('data',$this->operator_id)==1){ }else{ redirect("","refresh");}
    }
    public function index($cats = 1) {
        $this->cats = $cats;
        $this->all($cats, 1);
    }
      public function all() {
        $this->db->order_by('id', 'asc');
        $data['result'] = $this->db->get('datas')->result();
        $data['title'] = $this->lang->line('data');
        // $data['view'] = '../controllers/views/' . $this->thispage . '/all';
        $data['thispage'] = $this->thispage;
        $this->load->view('site/'.$this->thispage.'/all', $data);
    }
    public function add() {
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('lable', 'label', 'trim|required');
            if ($this->form_validation->run() === FALSE) {
                $add = FALSE;
            } else {
                $add = TRUE;
                $data = array(
                    'english' => $this->input->post('english'),
                    'arabic' => $this->input->post('arabic'),
                    'lable' => $this->input->post('lable'),
                    'create_on' => date("Y-m-d h:m:sa"),
                );
                $result = $this->db->insert('datas',$data);
                if ($result){
                    $this->session->set_flashdata('msg', 'success');
                    redirect(base_url('' . $this->thispage));
                }
            }
        }
        if(!$add){
            $data['title'] = 'datas';
            $data['thispage'] = 'datas';
            // $data['view'] = '../controllers/views/' . $this->thispage . '/add';
            $this->load->view('site/'. $this->thispage . '/add', $data);
        }
    }
    public function edit($id=" ")
    {
        if($this->input->server('REQUEST_METHOD') =="POST"){
            $data = $this->input->post();
            $data['last_update'] = date('Y-m-d h:m:sa');
            $data = $this->input->post();
            $this->db->where('id',$id);
            $result = $this->db->update('datas',$data);
             if ($result) {
                $this->session->set_flashdata('msg', 'change successfully');
                redirect(base_url('' . $this->thispage . '/all/'));
            }
        } 
            $this->db->from('datas');
            $this->db->where('id', $id);
            $data['result'] = $this->db->get()->row();
            $data['title'] = 'edit';
            $data['thispage'] = 'datas';
            // $data['view'] = '../controllers/views/' . $this->thispage . '/edit';
            $this->load->view('site/' . $this->thispage . '/edit', $data);
    }
    public function permission($id)
    {
        if($this->input->server('REQUEST_METHOD') =="POST"){
            $data_array = $this->input->post();
            foreach ($data_array as $key => $value) {
                   $array[] = array(
                                    'operator_id'       => $id,
                                    'permission_name'       => $key,
                                    'permission_status' => $value
                                );
                }
            // $data['last_update'] = date('Y-m-d h:m:sa');
            $this->db->where('operator_id',$id);
            $this->db->delete('permission');
            $result = $this->db->insert_batch('permission',$array);
             if ($result) {
                $this->session->set_flashdata('msg', 'change successfully');
                redirect(base_url('' . $this->thispage . '/permission/'.$id));
            }
        } 
            $this->db->from('groups');
            $this->db->where('id', $id);
            $data['result'] = $this->db->get('')->result() ;
            $data['title'] = 'permission';
            $data['thispage'] = 'groups';
            $data['view'] = 'controllers/views/' . $this->thispage . '/permission';
            $this->load->view('controllers/views/layout', $data);
    }
    public function delete($id="")
    {
        $this->db->where('id',$id);
        $result = $this->db->delete('datas');
        if ($result) {
            $this->session->set_flashdata('msg', 'delete successfully');
                redirect(base_url('' . $this->thispage . '/main'));
        }
    }
    
    function main() {
        if (!get_license_per('data_managment')) {
            redirect("", "refresh");
        }
        if (!get_ap('data', $this->operator_id)) {
            redirect("", "refresh");
        }
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('label', 'label', 'trim|required');
            if ($this->form_validation->run() === FALSE) {
                $data['title'] = 'datas';
                $data['thispage'] = 'datas';
                $this->load->view('site/'. $this->thispage . '/main', $data);
                return;
            } else {
                $data_id = $this->input->post('data_id');
                $data = array(
                    'english' => $this->input->post('english'),
                    'arabic' => $this->input->post('arabic'),
                    'lable' => $this->input->post('label')
                );
                if($data_id !='') {
                    $this->db->update('datas', $data, array('id' => $data_id));
                } else {
                     $this->db->insert('datas',$data);
                }
                
                $this->session->set_flashdata('msg', 'success');
                redirect(base_url('' . $this->thispage.'/main'));
                
            }
        }
        $data['title'] = 'datas';
        $data['thispage'] = 'datas';
        $this->load->view('site/'. $this->thispage . '/main', $data);
    }
    
    function get_data() {
        $label = $this->input->post('label');
        $res = $this->db->get_where('datas', array('lable' => $label))->result();
        echo json_encode($res);
    }

}

?>