<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Auth extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if (!get_system_status()) {
            echo $this->load->view('site/system_off', '', TRUE);
            die();
        }
        set_system_timezone();
        $this->load->library('mailer');

        $this->load->model('booking');
        $this->load->model('auth_model', 'auth_model');
    }

    // -------------------------------------------------------------------------
    public function index() {
        if ($this->session->has_userdata('is_admin_login')) {
            // redirect('admin/dashboard');
        }
        if ($this->session->has_userdata('is_user_login')) {
            // /redirect('user/profile');
        } else {
            if (@stristr($_SERVER['REQUEST_URI'], 'ltef')) {
                redirect('ltef/bills');
            } else {
                redirect('Auth/student_login');
            }

            // redirect('auth/login');
        }
    }

    // -------------------------------------------------------------------------
    public function login() {
        if ($this->session->userdata('is_admin_login')) {
            redirect('dashboard');
        }
        if ($this->input->server('REQUEST_METHOD') == "POST") {
            $this->form_validation->set_rules('name', 'name', 'trim|required');
            $this->form_validation->set_rules('password', 'Password', 'trim|required');
            if ($this->form_validation->run() == FALSE) {
                $this->load->view('auth/login');
                return;
            } else {
                $data = array(
                    'email' => $this->input->post('name'),
                    'password' => $this->input->post('password')
                );
                $data = $this->security->xss_clean($data);
                $result = $this->auth_model->login($data);
                if ($result) {
                    if ($result['approve_status'] == 0) {
                        $data['title'] = 'Login';
                        $data['msg'] = 'Your Account De active Contact Admin';
                        $data['view'] = 'auth/login';
                        $this->load->view('auth/login', $data);
                        // die();
                    } else {
                        //if ($result['gruop'] == 1 or $result['gruop'] == 2 or $result['gruop'] == 3) {
                        $group = TRUE;
                        $group1 = FALSE;
                        //if ($result['gruop'] == 1)
                        //  $group = TRUE;
                        //if ($result['gruop'] == 3)
                        //    $group1 = TRUE;

                        $admin_data = array(
                            'admin_id' => $result['id'],
                            'name' => $result['name'],
                            'email' => $result['email'],
                            'pass' => $result['pass'],
                            'group' => $group,
                            'editor' => $group1,
                            'access_level_group' => $result['operator_id'],
                            'iduser' => $result['id'],
                            'is_admin_login' => TRUE,
                        );

                        $this->session->set_userdata($admin_data);
                        $this->session->set_userdata('operator_id', $result['operator_id']);
                        $this->booking->add_rep_user(" تسجيل دخول");
                        rec_log('Login');
                        $lang = $this->db->get('setting')->row()->admin_default_lang;
                        if ($lang)
                            $this->session->set_userdata('language', $lang);

                        if (@stristr($_SERVER['REQUEST_URI'], 'ltef')) {
                            redirect('ltef/bills', 'refresh');
                        } else {
                            redirect('dashboard', 'refresh');
                        }
                        //}
                    }
                } else {
                    $data['title'] = 'Login';
                    $data['msg'] = 'Invalid Email or Password!';
                    $data['view'] = 'auth/login';
                    $this->load->view('auth/login', $data);
                }
            }
        } else {
            $data['title'] = 'Login';
            $data['view'] = 'auth/login';
            $this->load->view('auth/login', $data);
        }
    }

    public function student_login() {
        if ($this->session->userdata('is_student_login')) {
            redirect('students/inbox');
        }
        if ($this->session->userdata('is_admin_login')) {
            redirect('dashboard');
        }
        if ($this->input->server('REQUEST_METHOD') == "POST") {
            $this->form_validation->set_rules('name', 'name', 'trim|required');
            $this->form_validation->set_rules('password', 'Password', 'trim|required');
            if ($this->form_validation->run() == FALSE) {
                // $this->session->set_flashdata('error', validation_errors());
                //redirect(base_url('auth/student_login'));
            } else {
                $data = array(
                    'email' => $this->input->post('name'),
                    'password' => $this->input->post('password')
                );
                $data = $this->security->xss_clean($data);
                $result = $this->auth_model->student_login($data);
                // teacher login
                $result_teacher = FALSE;
                $controller_path = dirname(__DIR__);
                if (file_exists($controller_path . '/controllers/quraan')) {
                    $result_teacher = $this->auth_model->teacher_login($data);
                }

                if ($result) {
                    if ($result['approve_status'] == 0) {
                        $this->session->set_flashdata('error', 'Your Account is Deactive. Contact Admin');
                        redirect(base_url('auth/student_login'));
                    } else if ($result['block'] == 1) {
                        $this->session->set_flashdata('error', 'Your are blocked. Contact Admin');
                        redirect(base_url('auth/student_login'));
                    } else {

                        $admin_data = array(
                            'student_id' => $result['id'],
                            'name' => $result['username'],
                            'is_student_login' => TRUE
                        );
                        $this->session->set_userdata($admin_data);
                        $lang = $this->db->get('setting')->row()->student_default_lang;
                        if ($lang)
                            $this->session->set_userdata('language', $lang);
                        // $this->booking->add_rep_user(" تسجيل دخول طالب");
                        if (file_exists($controller_path . '/controllers/announcement')) {
                            redirect(base_url('Students/inbox'));
                        } else {
                            redirect(base_url('Students/membership'));
                        }
                    }
                } else if ($result_teacher) {
//                    if ($result_teacher['approve_status'] == 0) {
//                        $this->session->set_flashdata('error', 'Your Account is Deactive. Contact Admin');
//                        redirect(base_url('auth/student_login'));
//                    } else {
                    $admin_data = array(
                        'teacher_id' => $result_teacher['id'],
                        'name' => $result_teacher['name'],
                        'group' => TRUE,
                        'is_teacher_login' => TRUE
                    );
                    $this->session->set_userdata($admin_data);
                    //$this->session->set_userdata('operator_id', $result_teacher['operator_id']);
                    //$this->session->set_userdata($admin_data);
                    $lang = $this->db->get('setting')->row()->student_default_lang;
                    if ($lang)
                        $this->session->set_userdata('language', $lang);
                    // $this->booking->add_rep_user(" تسجيل دخول طالب");
                    redirect(base_url('quraan/sessions'));
                    // }
                } else {

                    $this->session->set_flashdata('error', 'Invalid Email or Password!');
                    redirect(base_url('auth/student_login'));
                }
            }
        }
        $data['title'] = 'Login';
        $data['view'] = 'auth/student_login';
        $data['required_fields'] = explode(',', $this->db->get('setting')->row()->customer_fields);
        $this->load->view('auth/student_login', $data);
    }

    public function driver_login() {
        if ($this->session->userdata('is_student_login')) {
            redirect('students/inbox');
        }
        if ($this->session->userdata('is_driver_login')) {
            redirect('drivers/Drivers/profile');
        }

        if ($this->session->userdata('is_admin_login')) {
            redirect('dashboard');
        }
        if ($this->input->server('REQUEST_METHOD') == "POST") {
            $this->form_validation->set_rules('name', 'name', 'trim|required');
            $this->form_validation->set_rules('password', 'Password', 'trim|required');
            if ($this->form_validation->run() == FALSE) {
                // $this->session->set_flashdata('error', validation_errors());
                // redirect(base_url('auth/driver_login'));
            } else {
                $data = array(
                    'email' => $this->input->post('name'),
                    'password' => $this->input->post('password')
                );
                $data = $this->security->xss_clean($data);
                $result = $this->auth_model->driver_login($data);


                if ($result) {
                    if ($result['status'] == 0) {
                        $this->session->set_flashdata('error', 'Your Account is Deactive. Contact Admin');
                        redirect(base_url('auth/driver_login'));
                    } else {

                        $admin_data = array(
                            'driver_id' => $result['id'],
                            'name' => $result['name'],
                            'is_driver_login' => TRUE
                        );
                        $this->session->set_userdata($admin_data);
                        rec_log('Login', 1);
                        // $this->booking->add_rep_user(" تسجيل دخول طالب");
                        redirect(base_url('drivers/Drivers_login/orders'));
                    }
                } else {

                    $this->session->set_flashdata('error', 'Invalid Email or Password!');
                    redirect(base_url('auth/driver_login'));
                }
            }
        }
        $data['title'] = 'Login';
        $data['view'] = 'auth/driver_login';
        $this->load->view('auth/driver_login', $data);
    }

    // -------------------------------------------------------------------------
    public function register() {
        $data['required_fields'] = explode(',', $this->db->get('setting')->row()->customer_fields);
        if ($this->input->server('REQUEST_METHOD') == "POST") {
            $fields_arr = array(
                'username' => $this->lang->line('name'),
//                'name' => $this->lang->line('username'),
                'cid_user' => $this->lang->line('civil-no'),
                'email' => $this->lang->line('e-mail'),
                'password' => $this->lang->line('password'),
                'phone' => $this->lang->line('students') . ' ' . $this->lang->line('mobile'),
                'phone_father' => $this->lang->line('guardian') . ' ' . $this->lang->line('mobile'),
                'country' => $this->lang->line('nationality'),
                'city' => $this->lang->line('region'),
                'blocks' => $this->lang->line('block'),
                'street' => $this->lang->line('street'),
                'jadah' => $this->lang->line('jadah'),
                'floor' => $this->lang->line('floor'),
                'door_no' => $this->lang->line('door-number'),
                'address_link' => $this->lang->line('address-link'),
                'title' => $this->lang->line('title'),
                'age' => $this->lang->line('date-of-birth'),
                'sex' => $this->lang->line('sex'),
                'father_work' => $this->lang->line('father_work'),
                'mother_work' => $this->lang->line('mother_work'),
                'social_status' => $this->lang->line('social_status'),
                'note' => $this->lang->line('note'),
            );


            foreach ($fields_arr as $key => $val) {
                if (in_array($key, $data['required_fields'])) {
                    $this->form_validation->set_rules($key, $val, 'trim|required');
                }
            }
            if ($this->input->post('email')) {
                $this->form_validation->set_rules('email', $this->lang->line('email'), 'trim|is_unique[bills_user.email]');
            }
            if ($this->input->post('username')) {
                $this->form_validation->set_rules('username', $this->lang->line('username'), 'trim|is_unique[bills_user.username]');
            }
            if ($this->input->post('phone')) {
                $this->form_validation->set_rules('phone', $this->lang->line('phone'), 'trim|is_unique[bills_user.phone]');
            }

            if ($this->form_validation->run() === FALSE) {
                $data['title'] = 'Create an Account';
                $this->session->set_flashdata('error', validation_errors());
                redirect(base_url('auth/student_login')); /* $this->load->view('auth/login', $data); */
            } else {
                $data = array(
                    'cid_user' => $this->input->post('cid_user'),
                    'username' => $this->input->post('username'),
                    'name' => $this->input->post('name'),
                    'email' => $this->input->post('email'),
                    'phone' => $this->input->post('phone'),
                    'phone_father' => $this->input->post('phone_father'),
                    'nationality' => $this->input->post('country'),
                    'region' => $this->input->post('city'),
                    //'city3' => $this->input->post('city3'),
                    'age' => $this->input->post('age'),
                    'sex' => $this->input->post('sex'),
                    'note' => $this->input->post('note'),
                    'blocks' => $this->input->post('blocks'),
                    'floor' => $this->input->post('floor'),
                    'jadah' => $this->input->post('jadah'),
                    'street' => $this->input->post('street'),
                    'door_no' => $this->input->post('door_no'),
                    //'country' => $this->input->post('blocks') . ' ' . $this->input->post('floor') . ' ' . $this->input->post('jadah') . ' ' . $this->input->post('street') . ' ' . $this->input->post('door_no'),
                    'address_link' => $this->input->post('address_link'),
                    'create_on' => date('m-d-Y m:h:sa'),
                    // 'imageuser' => $imageuser,
                    'approve_status' => 0,
                    'since_time_register' => $this->booking->tissme_now(),
                    'father_job' => $this->input->post('father_work'),
                    'mother_job' => $this->input->post('mother_work'),
                    'social_status' => $this->input->post('social_status'),
                );

                $data['pass'] = md5(md5($this->input->post('password')));
                //unset($data['password']);

                $this->db->insert('bills_user', $data);

                $result = $this->db->insert_id(); // =====================================================
                $this->load->library('upload');
                $dataInfo = array();
                $files = $_FILES;
                if ($_FILES['profile']['name']) {
                    $_FILES['userfile']['name'] = $files['profile']['name'];
                    $_FILES['userfile']['type'] = $files['profile']['type'];
                    $_FILES['userfile']['tmp_name'] = $files['profile']['tmp_name'];
                    $_FILES['userfile']['error'] = $files['profile']['error'];
                    $_FILES['userfile']['size'] = $files['profile']['size'];
                    $this->upload->initialize($this->set_upload_options());
                    $this->upload->do_upload();
                    $dataInfo = $this->upload->data();
                    $profile_image_name = $dataInfo['file_name'];
                    $this->db->insert('user_image', array(
                        'image' => $profile_image_name,
                        'user_id' => $result,
                        'profile_pic' => 1
                    ));
                }

                $cpt = count($_FILES['imageuser']['name']);
                for ($i = 0; $i < $cpt; $i ++) {
                    $_FILES['userfile']['name'] = $files['imageuser']['name'][$i];
                    $_FILES['userfile']['type'] = $files['imageuser']['type'][$i];
                    $_FILES['userfile']['tmp_name'] = $files['imageuser']['tmp_name'][$i];
                    $_FILES['userfile']['error'] = $files['imageuser']['error'][$i];
                    $_FILES['userfile']['size'] = $files['imageuser']['size'][$i];
                    $this->upload->initialize($this->set_upload_options());
                    $this->upload->do_upload();
                    $dataInfo[] = $this->upload->data();
                }
                for ($i = 0; $i < $cpt; $i ++) {
                    $datas[] = $dataInfo[$i]['file_name'];
                }
                if (!empty($datas)) {
                    $datass['image'] = implode(',', $datas);
                    $datass['user_id'] = $result;
                    $datass['create_on'] = date("m-d-Y h:m:sa");
                    $this->db->insert('user_image', $datass);
                }

                //echo $this->db->last_query();die;
                $this->session->set_flashdata('success', 1);
                redirect(base_url('auth/student_login'));
            }
        } else {
            $data['title'] = 'Create an Account';
            redirect(base_url('auth/student_login')); /* $this->load->view('auth/login', $data); */
        }
    }

    public function userRegister() {
        if ($this->input->server('REQUEST_METHOD') == "POST") {
            $this->form_validation->set_rules('name', 'Username', 'trim|required|is_unique[user_register.name]');
            $this->form_validation->set_rules('email', 'email', 'trim|is_unique[user_register.email]');
            if ($this->form_validation->run() == FALSE) {
                $data['title'] = 'Create an Account';
                $this->load->view('auth/registers', $data);
            } else {
                $data = $this->input->post();
                $data['BirthDate'] = $this->input->post('Birthday');
                $data['phone'] = $this->input->post('mobile');
                $data['create_on'] = date('Y-m-d h:m:sa');
                unset($data['Birthday']);
                unset($data['mobile']);
                $result = $this->db->insert('user_register', $data);
                $data = $this->security->xss_clean($data);
                if ($result) {
                    redirect(base_url('auth/user_register'));
                } else {
                    redirect(base_url('auth/user_register'));
                }
            }
        } else {
            $data['title'] = 'Create an Account';
            $this->load->view('auth/registers', $data);
        }
    }

    // ----------------------------------------------------------
    public function verify() {
        $verification_id = $this->uri->segment(3);
        $result = $this->auth_model->email_verification($verification_id);
        if ($result) {
            $this->session->set_flashdata('success', 'Your email has been verified, you can now login.');
            redirect(base_url('auth/login'));
        } else {
            $this->session->set_flashdata('success', 'The url is either invalid or you already have activated your account.');
            redirect(base_url('auth/login'));
        }
    }

    // --------------------------------------------------
    public function forgot_password() {
        if ($this->input->post('submit')) {
            // checking server side validation
            $this->form_validation->set_rules('email', 'Email', 'valid_email|trim|required');
            if ($this->form_validation->run() === FALSE) {
                $this->load->view('auth/forget_password');
                return;
            }
            $email = $this->input->post('email');
            $response = $this->auth_model->check_user_mail($email);
            if ($response) {
                $rand_no = rand(0, 1000);
                $pwd_reset_code = md5($rand_no . $response['id']);
                $this->auth_model->update_reset_code($pwd_reset_code, $response['id']);
                // --- sending email
                $name = $response['firstname'] . ' ' . $response['lastname'];
                $email = $response['email'];
                $reset_link = base_url('auth/reset-password/' . $pwd_reset_code);
                $body = $this->mailer->Tpl_PwdResetLink($name, $reset_link);

                $this->load->helper('email_helper');
                $to = $email;
                $subject = 'Reset your password';
                $message = $body;
                $email = sendEmail($to, $subject, $message);
                if ($email) {
                    $this->session->set_flashdata('success', 'We have sent instructions for resetting your password to your email');

                    redirect(base_url('auth/forgot-password'));
                } else {
                    $this->session->set_flashdata('error', 'There is the problem on your email');
                    redirect(base_url('auth/forgot-password'));
                }
            } else {
                $this->session->set_flashdata('error', 'The Email that you provided are invalid');
                redirect(base_url('auth/forgot-password'));
            }
        } else {
            $data['title'] = 'Forget Password';
            $this->load->view('auth/forget_password', $data);
        }
    }

    // --------------------------------------------------
    public function reset_password($id = 0) {
        // check the activation code in database
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[8]');
            $this->form_validation->set_rules('confirm_password', 'Password Confirmation', 'trim|required|matches[password]');

            if ($this->form_validation->run() == FALSE) {
                $result = false;
                $data['reset_code'] = $id;
                $data['title'] = 'Reseat Password';
                $this->load->view('auth/reset_password', $data);
            } else {
                $new_password = password_hash($this->input->post('password'), PASSWORD_BCRYPT);
                $this->auth_model->reset_password($id, $new_password);
                $this->session->set_flashdata('success', 'New password has been Updated successfully.Please login below');
                redirect(base_url('auth/login'));
            }
        } else {
            $result = $this->auth_model->check_password_reset_code($id);
            if ($result) {
                $data['reset_code'] = $id;
                $data['title'] = 'Reseat Password';
                $this->load->view('auth/reset_password', $data);
            } else {
                $this->session->set_flashdata('error', 'Password Reset Code is either invalid or expired.');
                redirect(base_url('auth/forgot-password'));
            }
        }
    }

    // -------------------------------------------------------------------------
    public function profile() {
        if ($this->input->post('submit')) {
            $data = array(
                'username' => $this->input->post('username'),
                'firstname' => $this->input->post('firstname'),
                'lastname' => $this->input->post('lastname'),
                'email' => $this->input->post('email'),
                'mobile_no' => $this->input->post('mobile_no'),
                'updated_at' => date('Y-m-d : h:m:s')
            );
            $data = $this->security->xss_clean($data);
            $result = $this->auth_model->update_admin($data);
            if ($result) {
                $this->session->set_flashdata('msg', 'Profile has been Updated Successfully!');
                redirect(base_url('auth/profile'), 'refresh');
            }
        } else {
            $data['admin'] = $this->auth_model->get_admin_detail();
            $data['title'] = 'User Profile';
            $data['view'] = 'auth/profile';
            $this->load->view('../controllers/admin/views/layout', $data);
        }
    }

    public function change_pwd() {
        $id = $this->session->userdata('admin_id');
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('password', 'Password', 'trim|required');
            $this->form_validation->set_rules('confirm_pwd', 'Confirm Password', 'trim|required|matches[password]');
            if ($this->form_validation->run() == FALSE) {
                $data['admin'] = $this->auth_model->get_admin_detail();
                $data['view'] = 'auth/profile';
                $this->load->view('../controllers/admin/views/layout', $data);
            } else {
                $data = array(
                    'password' => password_hash($this->input->post('password'), PASSWORD_BCRYPT)
                );
                $data = $this->security->xss_clean($data);
                $result = $this->auth_model->change_pwd($data, $id);
                if ($result) {
                    $this->session->set_flashdata('msg', 'Password has been changed successfully!');
                    redirect(base_url('auth/profile'));
                }
            }
        } else {
            $data['title'] = 'Change Password';
            $data['view'] = 'auth/change_pwd';
            $this->load->view('../controllers/admin/views/layout', $data);
        }
    }

    // -------------------------------------------------------------------------
    public function logout() {
        $teacher = 0;
        if ($this->session->userdata('teacher_id')) {
            $teacher = 1;
        }
        if ($this->session->userdata('admin_id')) {
            rec_log('Logout');
        }
        
        $this->booking->add_rep_user(" تسجيل خروج");
        $this->session->sess_destroy();
        // $this->session->unset_userdata();
        if ($teacher) {
            redirect(base_url('auth/student_login'), 'refresh');
        }
        redirect(base_url('auth/login'), 'refresh');
    }

    function show_invoice($id) {
        $query = $this->db->get_where('bills_orders', array('id' => $id));
        $data['show'] = $query->row_array();
        $query = $this->db->get_where('bills_user', array('id' => $data['show']['id_user']));
        $data['show2'] = $query->row_array();
        //$query = $this->db->get_where('bills_producer', array('id' => $data['show']['id_producer']));
        $this->db->select('name_order,start_date,expiry_date,payment,discount,quantity');
        $query = $this->db->get_where('bills_orders', array('id_orders' => $data['show']['id_orders']));
        $data['producer'] = $query->result();

        //total_price
        $this->db->select('sum(discount_remainder) as total_price');
        $this->db->group_by('id_orders');
        $data['price'] = $this->db->get_where('bills_orders', array('id_orders' => $data['show']['id_orders']))->row();

        $this->db->select('inv_footer,inv_footer_ar,inv_currency');
        $data['sett'] = $this->db->get('setting')->row();

        $data['title'] = '  عرض فاتورة';
        $this->load->view('site/show_invoice', $data);
    }

    private function set_upload_options() {
        // upload an image options
        $config = array();
        $config['upload_path'] = './public/upload/userimage/';
        $config['allowed_types'] = 'gif|jpg|png';
        $config['max_size'] = '0';
        $config['overwrite'] = FALSE;
        return $config;
    }

}

// end class
?>