<?php


defined('BASEPATH') or exit('No direct script access allowed');


class Store extends MY_Controller
{

    var $thispage;
    var $cats;

    public function __construct() {
        parent::__construct();
        $this->thispage = "Store";
        $this->load->model('Stores/Store_Model');
        $this->operator_id = $this->session->userdata('operator_id');
        if (get_ap('member', $this->operator_id) == 1 || $this->session->userdata('is_teacher_login')) {

        } else {
            redirect("", "refresh");
        }
        if (!$this->session->userdata('group') && !$this->session->userdata('is_teacher_login')) {
            echo "لايمكن الاستخدام ";
            $this->session->set_flashdata('msg', 'لايمكن التعديل عليه');
            // /echo $_SERVER['HTTP_REFERER'];
            redirect($_SERVER['HTTP_REFERER']);
            exit();
        }
    }

    public function index() {
//        if (!get_ap('teachers', $this->operator_id)) {
//            redirect("", "refresh");
//        }
        $this->all(1);
    }

    public function all($page = 1) {
        $this->db->select('stores.*');
//        $this->db->join('datas', 'datas.id = teachers.nationality', 'left');
        $data['rows'] = $this->db->get('stores')->result_array();

        $data['title'] = $this->lang->line('stores');
        // $data['view'] = '../controllers/views/'.$this->thispage.'/show';
        $data['cats'] = $this->cats;
        $data['thispage'] = $this->thispage;
        $this->load->view('site/' . $this->thispage . '/show', $data);
    }

    public function add($cats = 1) {
        if (!get_ap('teacher_add', $this->operator_id)) {
            redirect("", "refresh");
        }
        $add = FALSE;
        $this->cats = $cats;
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('name', $this->lang->line('the-name'), 'trim|required');
            $this->form_validation->set_rules('email', $this->lang->line('e-mail'), 'trim|required|is_unique[stores.email]');
			$this->form_validation->set_rules('phone', $this->lang->line('phone'), 'trim|required|is_unique[stores.phone]');
			$this->form_validation->set_rules('address', $this->lang->line('address'), 'required');

            if ($this->form_validation->run() === FALSE) {

                $add = FALSE;
            } else {
                $add = TRUE;
                $post_data = $this->input->post();

                unset($post_data['submit']);
                $this->db->insert('stores', $post_data);

                $this->session->set_flashdata('msg', 'تم اضافة المعلم بفضل الله!');
                redirect(base_url('Stores/Store'));
            }
        }
        if (!$add) {

            $data['title'] = $this->lang->line('add-a-store');

            $this->db->where('lable', 'nationality');
            $data['nationality'] = $this->db->get('datas')->result();

            $this->load->model('points/Tag_Model');
            $data['student_tags'] = $this->Tag_Model->get_tag(2);

            $data['thispage'] = $this->thispage;

            $data['view'] = '../controllers/views/' . $this->thispage . '/add';
            $this->load->view('site/' . $this->thispage . '/add', $data);
        }
    }


	public function edit($id) {
		if (!get_ap('teacher_edit', $this->operator_id)) {
			redirect("", "refresh");
		}
		$query = $this->db->get_where('stores', array(
			'id' => $id
		))->row_array();

		$add = FALSE;
		if ($this->input->post('submit')) {
			$this->form_validation->set_rules('name', $this->lang->line('the-name'), 'trim|required');
			$extra = '';
			if ($query['email'] != $this->input->post('email')) {
				$extra = '|is_unique[stores.email]';
			}
			$this->form_validation->set_rules('email', $this->lang->line('e-mail'), 'trim|required' . $extra);


			if ($this->form_validation->run() === FALSE) {

				$add = FALSE;
			} else {

				$add = TRUE;

				$edit_data = $this->input->post();

				unset($edit_data['submit']);

				$this->db->where('id', $id)->update('stores', $edit_data);

				$this->session->set_flashdata('msg', 'تم التعديل المخزن بفضل الله!');
				if ($this->session->has_userdata('is_teacher_login')) {
					$this->session->set_flashdata('success', $this->lang->line('op_success'));
					redirect(base_url('Stores/Store/edit/' . $id));
				} else {
					redirect(base_url('Stores/Store'));
				}
			}
		}

		if (!$add) {
			$data['title'] = $this->lang->line('edit') . ' ' . $this->lang->line('stores');


			$data['thispage'] = $this->thispage;
			$data['edit'] = $query;
			// $data['view'] = '../controllers/views/'.$this->thispage.'/edit';
			$this->load->view('site/' . $this->thispage . '/edit', $data);
		}
	}

	public function del($id) {
		if (!get_ap('teacher_del', $this->operator_id)) {
			redirect("", "refresh");
		}

		$this->db->delete('stores', array('id' => $id));

		$this->session->set_flashdata('msg', 'تم حذف المخزن بفضل الله!');
		redirect(base_url('Stores/Store'));
	}
}
